#ifndef IPHYSICALJOINT_H_
#define IPHYSICALJOINT_H_

#include "IPhysicalObject.h"
#include "IPhysicalBody.h"
#include "../DataTypes/DataJoint.h"

using namespace DataTypes;
namespace PhysicsEngine
{

class IPhysicalJoint : public PhysicsEngine::IPhysicalObject
{
public:
	IPhysicalJoint();
	IPhysicalJoint(int objectid, IPhysicalBody *body1, IPhysicalBody *body2);
	virtual ~IPhysicalJoint();
	IPhysicalBody *GetBody1();
	IPhysicalBody *GetBody2();
	void SetBody1(IPhysicalBody *body);
	void SetBody2(IPhysicalBody *body);
	DataObject *GetDataObject();
	virtual DataJoint* GetDataJoint()=0;
	virtual void UpdateData()=0;
private:
	IPhysicalBody *body1;
	IPhysicalBody *body2;
};

}

#endif /*IPHYSICALJOINT_H_*/
